/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.demo.intellijthemes;

import com.formdev.flatlaf.demo.intellijthemes.IJThemeInfo;
import com.formdev.flatlaf.demo.intellijthemes.IJThemesManager;
import com.formdev.flatlaf.json.Json;
import com.formdev.flatlaf.json.ParseException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;

public class IJThemesDuplicateNameChecker {
    public static void main(String[] args) {
        IJThemesManager themesManager = new IJThemesManager();
        themesManager.loadBundledThemes();
        HashSet<String> names = new HashSet<String>();
        for (IJThemeInfo ti : themesManager.bundledThemes) {
            String name;
            if (ti.sourceCodeUrl == null || ti.sourceCodePath == null) continue;
            String jsonPath = "../flatlaf-intellij-themes/src/main/resources/com/formdev/flatlaf/intellijthemes/themes/" + ti.resourceName;
            try {
                name = IJThemesDuplicateNameChecker.readNameFromJson(jsonPath);
            }
            catch (IOException ex) {
                System.err.println("Failed to read '" + jsonPath + "'");
                continue;
            }
            if (names.contains(name)) {
                System.out.println("Duplicate name '" + name + "'");
            }
            names.add(name);
        }
    }

    private static String readNameFromJson(String jsonPath) throws IOException {
        String string;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonPath), StandardCharsets.UTF_8);
        try {
            Map json = (Map)Json.parse(reader);
            string = (String)json.get("name");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

